/**
 * Hourglass for PIC16F18346
 * 
 *  MODE  1 RE3/MCLR  DAT/RB7 40 MINUS
 *  R5A   2 RA0           RB6 39 PLUS
 *  R7A   3 RA1           RB5 38 C1A
 *  C3A   4 RA2           RB4 37 C6A
 *  R8A   5 RA3           RB3 36 C4A
 *  R6A   6 RA4           RB2 35 C7A
 *  R3A   7 RA5           RB1 34 C8A
 *  C5A   8 RE0           RB0 33 VIBRATION
 *  C2A   9 RE1           VDD 32 VDD
 *  C2B  10 RE2           VSS 31 VSS
 *  VDD  11 VDD           RD7 30 R1A
 *  VSS  12 VSS           RD6 29 R4A
 *  R5B  13 RA7           RD5 28 R2A
 *  R7B  14 RA6           RD4 27 C8B
 *  C3B  15 RC0           RC7 26 C7B
 *  R8B  16 RC1           RC6 25 R2B
 *  C5B  17 RC2           RC5 24 C1B
 *  R6B  18 RC3           RC4 23 R4B
 *  R3B  19 RD0           RD3 22 C6B
 *  R1B  20 RD1           RD2 21 C4B
 * 
 * MPLAB X IDE v5.30 with XC8 Ver2.30
 * (c)2020 Futoshi Sumikawa. 2020/11/26
 */

/**
  Generated Main Source File

  Company:
    Microchip Technology Inc.

  File Name:
    main.c

  Summary:
    This is the main file generated using PIC10 / PIC12 / PIC16 / PIC18 MCUs

  Description:
    This header file provides implementations for driver APIs for all modules selected in the GUI.
    Generation Information :
        Product Revision  :  PIC10 / PIC12 / PIC16 / PIC18 MCUs - 1.81.6
        Device            :  PIC16F18877
        Driver Version    :  2.00
*/
/*

Hourglass

System Module
  CurrentSYsytem clock 32MHz

PWM6
  Enalbe PWM
  Select a Timer Timer2
  +Duty Cycle
    Duty Cycle 50.0%
    PWMDC Value 799
  +PWM Parameters
    PWM Polarity active_lo
    PWM period 5 us
    PWM Fequency 200 kHz
    PWM Resolution 7 Bits

PWM7
  Enalbe PWM
  Select a Timer Timer2
  +Duty Cycle
    Duty Cycle 50.0%
    PWMDC Value 799
  +PWM Parameters
    PWM Polarity active_lo
    PWM period 5 us
    PWM Fequency 200 kHz
    PWM Resolution 7 Bits
   
TMR0
  Enalbe Timer
  +Timer Clock
    Clock prescaler 1:64
    Postscaler 1:10
    Timer mode: 8-Bit
    Clock Source: FOSC/4
    Enable Synchronisation
  +Timer Period
    Requestd Period: 20 ms
    Actual Period: 20 ms

TMR1
  Enable Timer
  +Timer Clock
    Clock Source: FOSC/4
    Postscaler 1:1
    Enable Synchronisation
  +Timer Period
    Requestd Period: 250 us
    Actual Period: 250 us
  Enable Timer Interrupt
  +Software Settings
    Callback function Rate 1 x Time Period = 250 us

TMR2
  +Hardware Settings
    Enable Timer
    Control Mode Roll over pulse
    Start/Reset Option Software control
  +Timer Clock
    Clock Source: FOSC/4 Enable Clock Sync
    Polarity Rising Edge
    Prescaler 1:1
    Postscaler 1:1
    Enable Synchronisation
  +Timer Period
    Requestd Period: 5 us
    Actual Period: 5 us 
 
 */


/*
    (c) 2018 Microchip Technology Inc. and its subsidiaries. 
    
    Subject to your compliance with these terms, you may use Microchip software and any 
    derivatives exclusively with Microchip products. It is your responsibility to comply with third party 
    license terms applicable to your use of third party software (including open source software) that 
    may accompany Microchip software.
    
    THIS SOFTWARE IS SUPPLIED BY MICROCHIP "AS IS". NO WARRANTIES, WHETHER 
    EXPRESS, IMPLIED OR STATUTORY, APPLY TO THIS SOFTWARE, INCLUDING ANY 
    IMPLIED WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY, AND FITNESS 
    FOR A PARTICULAR PURPOSE.
    
    IN NO EVENT WILL MICROCHIP BE LIABLE FOR ANY INDIRECT, SPECIAL, PUNITIVE, 
    INCIDENTAL OR CONSEQUENTIAL LOSS, DAMAGE, COST OR EXPENSE OF ANY KIND 
    WHATSOEVER RELATED TO THE SOFTWARE, HOWEVER CAUSED, EVEN IF MICROCHIP 
    HAS BEEN ADVISED OF THE POSSIBILITY OR THE DAMAGES ARE FORESEEABLE. TO 
    THE FULLEST EXTENT ALLOWED BY LAW, MICROCHIP'S TOTAL LIABILITY ON ALL 
    CLAIMS IN ANY WAY RELATED TO THIS SOFTWARE WILL NOT EXCEED THE AMOUNT 
    OF FEES, IF ANY, THAT YOU HAVE PAID DIRECTLY TO MICROCHIP FOR THIS 
    SOFTWARE.
*/

#include "mcc_generated_files/mcc.h"
#include "vram.h"
#include "font.h"

#define DATAEE_NONE                0x7000
#define DATAEE_TIME_TO_CALCULATE   0x7001
#define DATAEE_TIME_ADJUST         0x7002

#define MODE_HELLO     1
#define MODE_RUN       2
#define MODE_OVER      3
#define MODE_SET       4
#define MODE_ADJUST    5

#define COLOR_0    0
#define COLOR_1    1
#define COLOR_2    2
#define COLOR_3    3

#define UPPER_LIMIT_OF_VIBRATION_TIME_IN_RUN_MODE 60000
#define CHATTERING_TIME 20
#define DEFAULT_CALCULATE_TIME 3
#define MIN_CALCULATE_TIME  1
#define MAX_CALCULATE_TIME 99
#define PUSH_TIME_TO_ENTER_ADJUSTMENT 2000
#define WAITING_TIME_FOR_ROTATION 300
#define DISPLAY_TIME_OF_TIME 1100            
#define SETTINGS_TO_DISPLAY_TIME_OUT 600
#define SETTINGS_TO_DISPLAY_HELLO 100
#define TIME_TO_TILT_TO_GET_STARTED 800

// Color palette (0 - 159)
// f(x) = (160x^2)/36-1
// 0, 2, 17, 39, 70, 110, 159
const uint8_t _COLOR_PALETTE0[] = {0, 17, 70, 159};
const uint8_t _COLOR_PALETTE1[] = {0, 39, 110, 159};

uint8_t _row = 1;
uint8_t _col = 1;

int8_t _tenMin = 0;
int8_t _oneMin = 0;
int8_t _tenSec = 0;
int8_t _oneSec = 0;
uint16_t _ms = 0;
uint16_t _numberOf100ms = 0;
uint8_t _cycle = 0;
uint8_t _cycle100ms = 0;

uint16_t _swVibrationTime = 0;
uint16_t _swPushSetTime = 0;
uint16_t _swPushPlusTime = 0;
uint16_t _swPushMinusTime = 0;

uint8_t _swVibration = 0;
uint8_t _swPushSet = 1;
uint8_t _swPushPlus = 1;
uint8_t _swPushMinus = 1;

uint8_t _mode = MODE_HELLO;
uint8_t _timeToCalculate = DEFAULT_CALCULATE_TIME;
int8_t _timeAdjust = 0;
uint8_t _paletteType = 0;

void turnOffDisplay() {

    LATA = 0b00000000;
    LATB = 0b11000000;
    LATC = 0b00000000;
    LATD = 0b00000000;
    LATE = 0b00001000;

    RD7PPS = 0x0; // R1A PWM6
    RD5PPS = 0x0; // R2A PWM6
    RA5PPS = 0x0; // R3A PWM6 PWM7
    RD6PPS = 0x0; // R4A PWM6
    RA0PPS = 0x0; // R5A PWM6 PWM7
    RA4PPS = 0x0; // R6A PWM6 PWM7
    RA1PPS = 0x0; // R7A PWM6 PWM7
    RA3PPS = 0x0; // R8A PWM6 PWM7

    RD1PPS = 0x0; // R1B PWM6
    RC6PPS = 0x0; // R2B      PWM7
    RD0PPS = 0x0; // R3B PWM6
    RC4PPS = 0x0; // R4B      PWM7
    RA7PPS = 0x0; // R5B PWM6 PWM7
    RC3PPS = 0x0; // R6B      PWM7
    RA6PPS = 0x0; // R7B PWM6 PWM7
    RC1PPS = 0x0; // R8B      PWM7

}

void saveTimeAdjust() {
    TMR1_StopTimer();
    turnOffDisplay();
    DATAEE_WriteByte(DATAEE_TIME_ADJUST, (uint8_t)_timeAdjust);
    TMR1_StartTimer();
}

int8_t loadTimeAdjust() {
    int8_t ms = (int8_t)DATAEE_ReadByte(DATAEE_TIME_ADJUST);
    return ms;
}


void saveTimeToCalculate() {
    TMR1_StopTimer();
    turnOffDisplay();
    DATAEE_WriteByte(DATAEE_TIME_TO_CALCULATE, _timeToCalculate);
    TMR1_StartTimer();
}

uint8_t loadTimeToCalculate() {
    uint8_t min = DATAEE_ReadByte(DATAEE_TIME_TO_CALCULATE);
    return min;
}

void clearTimer() {
    _tenMin = 0;
    _oneMin = 0;
    _tenSec = 0;
    _oneSec = 0;
    _ms = 0;
    _numberOf100ms = 0;
    _cycle = 0;
    _cycle100ms = 0;
}

void setTimer(uint8_t min, uint8_t sec) {
    clearTimer();
    _tenMin = (int8_t)min / 10;
    _oneMin = (int8_t)min % 10;
    _tenSec = (int8_t)sec / 10;
    _oneSec = (int8_t)sec % 10;
    _ms = 0;
    _numberOf100ms = 0;
    _cycle = 0;
    _cycle100ms = 0;
}

uint8_t isTimeOver(void) {
    if (_tenMin == 0 && _oneMin == 0 && _tenSec == 0 && _oneSec == 0) {
        return 1;
    }
    return 0;
}

void setPaletteType(uint8_t type) {
    _paletteType = type;
}

uint8_t getDutyValue(uint8_t color) {    
    if (_paletteType == 1) {
        return _COLOR_PALETTE1[color];
    } else {
        return _COLOR_PALETTE0[color];
    }
}

void TMR_InterruptHandler(void) {

    // cycle 250 us.
  
    // get data.
    uint8_t dataA = vramPeekBuffer((_row - 1) * 8 + _col - 1);
    uint8_t dutyA = getDutyValue(dataA);
    uint8_t dataB = vramPeekBuffer((16 - _row) * 8 + _col - 1);
    uint8_t dutyB = getDutyValue(dataB);

    // clear.
    LATA = 0b11111011;
    LATB = 0b11000001;
    LATC = 0b01011010;
    LATD = 0b11100011;
    LATE = 0b00001000;

    RD7PPS = 0x0; // R1A PWM6
    RD5PPS = 0x0; // R2A PWM6
    RA5PPS = 0x0; // R3A PWM6 PWM7
    RD6PPS = 0x0; // R4A PWM6
    RA0PPS = 0x0; // R5A PWM6 PWM7
    RA4PPS = 0x0; // R6A PWM6 PWM7
    RA1PPS = 0x0; // R7A PWM6 PWM7
    RA3PPS = 0x0; // R8A PWM6 PWM7

    RD1PPS = 0x0; // R1B PWM6
    RC6PPS = 0x0; // R2B      PWM7
    RD0PPS = 0x0; // R3B PWM6
    RC4PPS = 0x0; // R4B      PWM7
    RA7PPS = 0x0; // R5B PWM6 PWM7
    RC3PPS = 0x0; // R6B      PWM7
    RA6PPS = 0x0; // R7B PWM6 PWM7
    RC1PPS = 0x0; // R8B      PWM7

    if (_row == 1) {
        // ROW1
        PWM6_LoadDutyValue(dutyA);
        PWM7_LoadDutyValue(dutyB);
        RD7PPS = 0x0E; // R1A PWM6
        RC1PPS = 0x0F; // R8B PWM7
    } else if (_row == 2) {
        // ROW2
        PWM6_LoadDutyValue(dutyA);
        PWM7_LoadDutyValue(dutyB);
        RD5PPS = 0x0E; // R2A PWM6
        RA6PPS = 0x0F; // R7B PWM6 PWM7
    } else if (_row == 3) {
        // ROW3
        PWM6_LoadDutyValue(dutyA);
        PWM7_LoadDutyValue(dutyB);
        RA5PPS = 0x0E; // R3A PWM6 PWM7
        RC3PPS = 0x0F; // R6B      PWM7
    } else if (_row == 4) {
        // ROW4
        PWM6_LoadDutyValue(dutyA);
        PWM7_LoadDutyValue(dutyB);
        RD6PPS = 0x0E; // R4A PWM6
        RA7PPS = 0x0F; // R5B PWM6 PWM7
    } else if (_row == 5) {
        // ROW5
        PWM6_LoadDutyValue(dutyA);
        PWM7_LoadDutyValue(dutyB);
        RA0PPS = 0x0E; // R5A PWM6 PWM7
        RC4PPS = 0x0F; // R4B      PWM7
    } else if (_row == 6) {
        // ROW6
        PWM7_LoadDutyValue(dutyA);
        PWM6_LoadDutyValue(dutyB);
        RA4PPS = 0x0F; // R6A PWM6 PWM7
        RD0PPS = 0x0E; // R3B PWM6
    } else if (_row == 7) {
        // ROW7
        PWM6_LoadDutyValue(dutyA);
        PWM7_LoadDutyValue(dutyB);
        RA1PPS = 0x0E; // R7A PWM6 PWM7
        RC6PPS = 0x0F; // R2B      PWM7
    } else if (_row == 8) {
        // ROW8
        PWM7_LoadDutyValue(dutyA);
        PWM6_LoadDutyValue(dutyB);
        RA3PPS = 0x0F; // R8A PWM6 PWM7
        RD1PPS = 0x0E; // R1B PWM6
    }
    
    if (_col == 1) {
        COL1A_SetHigh();
        COL1B_SetHigh();
    } else if (_col == 2) {
        COL2A_SetHigh();
        COL2B_SetHigh();
    } else if (_col == 3) {
        COL3A_SetHigh();
        COL3B_SetHigh();
    } else if (_col == 4) {
        COL4A_SetHigh();
        COL4B_SetHigh();
    } else if (_col == 5) {
        COL5A_SetHigh();
        COL5B_SetHigh();
    } else if (_col == 6) {
        COL6A_SetHigh();
        COL6B_SetHigh();
    } else if (_col == 7) {
        COL7A_SetHigh();
        COL7B_SetHigh();
    } else if (_col == 8) {
        COL8A_SetHigh();
        COL8B_SetHigh();
    }

    _col++;
    if (_col > 8) {
        _col = 1;
        _row++;
        if (_row > 8) {
            _row = 1;
        }
    }

    _cycle++;
    if (_cycle >= 4) {
        _cycle = 0;
        _ms++;
        _swVibrationTime++;
        _swPushSetTime++;
        _swPushPlusTime++;
        _swPushMinusTime++;        
        _cycle100ms++;
        if (_cycle100ms >= 100) {
            _cycle100ms = 0;
            _numberOf100ms++;
        }
        
        if (_ms >= 1000 + _timeAdjust) {
            _ms = 0;
            _oneSec--;
            if (_oneSec < 0) {
                _oneSec = 9;
                _tenSec--;
                if (_tenSec < 0) {
                    _tenSec = 5;
                    _oneMin--;
                    if (_oneMin < 0) {
                        _oneMin = 9;
                        _tenMin--;
                    }
                }
            }
        }
    }    
}

void displayTimeAdjust(uint8_t color) {

    vramSetColor(color);
    
    uint8_t sign = 0x3a;
    uint16_t v = (uint16_t)_timeAdjust;
    if (_timeAdjust < 0) {
        v = (uint16_t)((int16_t)_timeAdjust * (-1));
        sign = 0x3b;
    }
    uint8_t hun = (uint8_t)(v / 100);
    uint8_t ten = (uint8_t)(v - (hun * 100)) / 10;
    uint8_t one = v % 10;

    vramSetFont(FONT_LED_3x7);
    vramSetPosition(-4, 0);
    vramPut(sign ,1);
    vramSetPosition(0, 0);
    vramPut('0' + (uint8_t)hun ,1);
    vramSetPosition(4, 0);
    vramPut('0' + (uint8_t)ten ,1);
    vramSetPosition(8, 0);
    vramPut('0' + (uint8_t)one ,1);
    
}

void displayTimeToCalculate(uint8_t color) {
    
    vramSetColor(color);
    uint8_t ten = _timeToCalculate / 10;
    uint8_t one = _timeToCalculate % 10;

    vramSetFont(FONT_MISAKI);
    vramSetPosition(0, 0);
    vramPut('0' + (uint8_t)ten ,1);
    vramSetPosition(8, 0);
    vramPut('0' + (uint8_t)one ,1);
}


void displayCircle() {

    uint8_t n = 4 - _numberOf100ms % 4;
    
    vramSetFont(FONT_CIRCLE);


    vramSetPosition(0, -6);
    vramSetColor(n + 1);
    vramPut(3, 0);
    vramSetPosition(0, -5);
    vramSetColor(n + 0);
    vramPut(3, 0);

    
    vramSetPosition(0, -4);
    vramSetColor(n + 3);
    vramPut(3, 0);
    vramSetPosition(0, -3);
    vramSetColor(n + 2);
    vramPut(3, 0);
    vramSetPosition(0, -2);
    vramSetColor(n + 1);
    vramPut(3, 0);
    vramSetPosition(0, -1);
    vramSetColor(n + 0);
    vramPut(3, 0);

    
    vramSetPosition(0, 0);
    vramSetColor(n + 0);
    vramPut(0, 0);
    
    vramSetColor(n + 1);
    vramPut(1, 0);
    vramSetColor(n + 2);
    vramPut(2, 0);
    vramSetColor(n + 3);
    vramPut(3, 0);


    vramSetPosition(8, 6);
    vramSetColor(n + 1);
    vramPut(7, 0);
    vramSetPosition(8, 5);
    vramSetColor(n + 0);
    vramPut(7, 0);

    
    vramSetPosition(8, 4);
    vramSetColor(n + 3);
    vramPut(7, 0);
    vramSetPosition(8, 3);
    vramSetColor(n + 2);
    vramPut(7, 0);
    vramSetPosition(8, 2);
    vramSetColor(n + 1);
    vramPut(7, 0);
    vramSetPosition(8, 1);
    vramSetColor(n + 0);
    vramPut(7, 0);
    
    
    vramSetPosition(8, 0);
    vramSetColor(n + 0);
    vramPut(4, 1);
    vramSetColor(n + 1);
    vramPut(5, 1);
    vramSetColor(n + 2);
    vramPut(6, 1);
    vramSetColor(n + 3);
    vramPut(7, 1);

    
}

void displayHourglass(uint8_t index, uint8_t color) {
    
    vramSetColor(color);
    
    // Lower
    uint16_t lowerIndex = 142 * (uint16_t)index / 255;
    vramSetFont(FONT_HOURGLASS_LOWER);
    vramSetPosition(8, 0);
    if (lowerIndex < 29) {
        vramPut((uint8_t)lowerIndex, 1);
    } else if (lowerIndex < 129) {
        uint8_t b = (uint8_t)lowerIndex - 8;
        uint8_t c = b / 20;
        uint8_t d = b % 20;
        vramSetPosition(8, (int8_t)(0 - c));
        vramPut(0x08 + d, 1);
        
        for (uint8_t i = 0; i < c; i++) {
            for (uint8_t x = 0; x < 8; x++) {
                vramPset(x + 8, 7 - i, color, 1);
            }
        }
        
    } else {
        vramPut(0x1d + (uint8_t)lowerIndex - 129, 1);
    }

    // Flow
    uint8_t f = _numberOf100ms % 4;
    vramPset(11, 0 + f, color, 0);
    vramPset(11, 4 + f, color, 0);
    vramPset(12, (uint8_t)(-2 + f), color, 0);
    vramPset(12, 2 + f, color, 0);
    vramPset(12, 6 + f, color, 0);
    
    // Upper
    uint16_t upperIndex = 68 * (uint16_t)index / 255;
    vramSetFont(FONT_HOURGLASS_UPPER);
    vramSetPosition(0, 0);
    if (upperIndex < 23) {
        vramPut((uint8_t)upperIndex, 1);
    } else if (upperIndex < 55) {
        uint8_t b = (uint8_t)upperIndex - 14;
        uint8_t c = b / 8;
        uint8_t d = b % 8;
        vramSetPosition(0, (int8_t)c);
        vramPut(0x0e + d, 1);

        vramPset(0, 6, 0, 0);
        vramPset(0, 7, 0, 0);
        vramPset(1, 7, 0, 0);
        vramPset(2, 7, 0, 0);
        vramPset(5, 7, 0, 0);
        vramPset(6, 7, 0, 0);
        vramPset(7, 7, 0, 0);
        vramPset(7, 6, 0, 0);
        
    } else {
        vramPut(0x17 + (uint8_t)upperIndex - 55, 1);
    }
    
    vramCylinderEffect();    
}

void rotateTime() {

    int16_t elapsedSec = (_tenMin * 10 + _oneMin) * 60 + _tenSec * 10 + _oneSec;
    int16_t remainingSec = (int16_t)_timeToCalculate * 60 - (int16_t)elapsedSec;
    
    int8_t min = (int8_t)(remainingSec / 60);
    _tenMin = min / 10;
    _oneMin = min % 10;
    int8_t sec = remainingSec % 60;
    _tenSec = sec / 10;
    _oneSec = sec % 10;
    
    _numberOf100ms = (uint16_t)((uint24_t)elapsedSec * (uint16_t)(1000 + _timeAdjust) / 100);
    
}

void displayTime(uint8_t color, uint8_t xor) {
    vramSetColor(color);
    if (_tenMin > 0) {
        vramSetFont(FONT_LED_3x7);
        vramSetPosition(-4, 0);
        vramPut('0' + (uint8_t)_tenMin ,xor);
        vramSetPosition(0, 0);
        vramPut('0' + (uint8_t)_oneMin ,xor);
    } else {
        vramSetFont(FONT_MISAKI);
        vramSetPosition(0, 0);
        vramPut('0' + (uint8_t)_oneMin ,xor);
    }
    vramSetFont(FONT_LED_3x7);
    vramSetPosition(4, 0);
    vramPut('0' + (uint8_t)_tenSec ,xor);
    vramSetPosition(8, 0);
    vramPut('0' + (uint8_t)_oneSec ,xor);
    
}

void displayHello(uint8_t type,  uint8_t color, uint8_t xor) {

    vramSetColor(color);
    
    vramSetFont(FONT_HOURGLASS_LOWER);
    vramSetPosition(8, 0);
    if (type == 0) {
        vramPut(0x20 ,xor);
    } else {
        vramPut(0x2a ,xor);
    }
    vramCylinderEffect();    

    uint8_t ten = _timeToCalculate / 10;
    uint8_t one = _timeToCalculate % 10;
    
    if (ten > 0) {
        vramSetFont(FONT_LED_3x7);
        vramSetPosition(-4, 0);
        vramPut('0' + (uint8_t)ten ,xor);
        vramSetPosition(0, 0);
        vramPut('0' + (uint8_t)one ,xor);
    } else {
        vramSetFont(FONT_MISAKI);
        vramSetPosition(0, 0);
        vramPut('0' + (uint8_t)one ,xor);
    }
    
}

void setMode(uint8_t mode) {
    _mode = mode;
    _swVibrationTime = 0;
}

void powerOff() {
    turnOffDisplay();
    SLEEP();
    NOP();
    clearTimer();
    setMode(MODE_HELLO);
}


/*
                         Main application
 */
void main(void)
{
    // initialize the device
    SYSTEM_Initialize();

    // When using interrupts, you need to set the Global and Peripheral Interrupt Enable bits
    // Use the following macros to:

    // Enable the Global Interrupts
    INTERRUPT_GlobalInterruptEnable();

    // Enable the Peripheral Interrupts
    INTERRUPT_PeripheralInterruptEnable();

    // Disable the Global Interrupts
    //INTERRUPT_GlobalInterruptDisable();

    // Disable the Peripheral Interrupts
    //INTERRUPT_PeripheralInterruptDisable();

    TMR1_SetInterruptHandler(TMR_InterruptHandler);

    _timeToCalculate = loadTimeToCalculate();
    if (_timeToCalculate < MIN_CALCULATE_TIME || _timeToCalculate > MAX_CALCULATE_TIME) {
        _timeAdjust = 0;
        saveTimeAdjust();
        _timeToCalculate = DEFAULT_CALCULATE_TIME;
        saveTimeToCalculate();
    }
    _timeAdjust = loadTimeAdjust();

    uint8_t futureVibration = 0;
    
    while (1)
    {
        // Add your application code

        if (SET_GetValue() == 0) {
            // sw down
            if (_swPushSet == 0) {
                if (_swPushSetTime > CHATTERING_TIME) {
                    // sw on
                    _swPushSet = 2;
                }
            } else if (_swPushSet == 1) {
                    // sw up -> down
                _swPushSet = 0;
                _swPushSetTime = 0;
            } else if (_swPushSet == 2) {
                // sw on -> hold
                if (_swPushSetTime > PUSH_TIME_TO_ENTER_ADJUSTMENT) {
                    _swPushSet = 3;
                    setMode(MODE_ADJUST);
                }
            }
        } else {
            // sw up
            if (_swPushSet == 2) {
                // sw on -> off
                if (_mode == MODE_HELLO) {
                    setMode(MODE_SET);
                } else {
                    clearTimer();
                    setMode(MODE_HELLO);
                }
            }
            _swPushSet = 1;
        }            
       
        vramClear();
        setPaletteType(0);
        
        if (_mode == MODE_HELLO) {
            
            displayHello(0, COLOR_3, 0);
            
            if (_numberOf100ms > SETTINGS_TO_DISPLAY_HELLO) {
                powerOff();
            }
            
            uint8_t displayVibration = _swVibration;
            
            uint8_t vibration = VIBRATION_GetValue(); 
            if (_swVibration != vibration) {
                if (_swVibrationTime > TIME_TO_TILT_TO_GET_STARTED) {
                    _swVibration = vibration;
                    futureVibration = vibration;
                    setTimer(_timeToCalculate, 0);
                    setMode(MODE_RUN);
                    _swVibrationTime = UPPER_LIMIT_OF_VIBRATION_TIME_IN_RUN_MODE;
                }
                displayHello(1, COLOR_3, 0);
                _numberOf100ms = 0;
            } else {
                _swVibrationTime = 0;
            }

            if (displayVibration) {
                vramRotateRight();
            } else {
                vramRotateLeft();
            }
            
        } else if (_mode == MODE_RUN) {

            if (isTimeOver()) {
                clearTimer();
                setMode(MODE_OVER);
            }
            uint24_t timeToCalculate100ms = (uint24_t)(1000 + _timeAdjust) * _timeToCalculate * 6 / 10;
            uint24_t index = (uint24_t)255 * _numberOf100ms / timeToCalculate100ms;
            displayHourglass((uint8_t)index, COLOR_3);
            
            uint8_t vibration = VIBRATION_GetValue(); 
            if (futureVibration != vibration) {
                futureVibration = vibration;
                _swVibrationTime = 0;
            }
            if (_swVibrationTime < WAITING_TIME_FOR_ROTATION) {
                // Waiting time for rotation.
            } else if (_swVibrationTime < DISPLAY_TIME_OF_TIME) {
                if (_swVibration != futureVibration) {
                    _swVibration = futureVibration;
                    rotateTime();
                }
                vramClear();
                displayTime(COLOR_3, 0);
            } else {
                _swVibrationTime = UPPER_LIMIT_OF_VIBRATION_TIME_IN_RUN_MODE;
            }
            
            if (_swVibration) {
                vramRotateRight();
            } else {
                vramRotateLeft();
            }

        } else if (_mode == MODE_OVER) {
            
            setPaletteType(1);
            displayCircle();
            vramRotateRight();

            if (_numberOf100ms < SETTINGS_TO_DISPLAY_TIME_OUT) {
                if (_swVibration != VIBRATION_GetValue())  {
                    clearTimer();
                    setMode(MODE_HELLO);
                }
            } else {
                powerOff();
            }
            
        } else if (_mode == MODE_SET) {
            
            displayTimeToCalculate(COLOR_3);
            
            if (PLUS_GetValue() == 0) {
                if (_swPushPlus == 0) {
                    if (_swPushPlusTime > CHATTERING_TIME) {
                        // sw on
                        _swPushPlus = 2;
                        if (_timeToCalculate < MAX_CALCULATE_TIME) {
                            _timeToCalculate++;
                            saveTimeToCalculate();
                        }
                    }
                } else if (_swPushPlus == 1) {
                    _swPushPlus = 0;
                    _swPushPlusTime = 0;
                }
            } else {
                _swPushPlus = 1;
            }            

            if (MINUS_GetValue() == 0) {
                if (_swPushMinus == 0) {
                    if (_swPushMinusTime > CHATTERING_TIME) {
                        // sw on
                        _swPushMinus = 2;
                        if (_timeToCalculate > MIN_CALCULATE_TIME) {
                            _timeToCalculate--;
                            saveTimeToCalculate();
                        }
                    }
                } else if (_swPushMinus == 1) {
                    _swPushMinus = 0;
                    _swPushMinusTime = 0;
                }
            } else {
                _swPushMinus = 1;
            }
            
        } else if (_mode == MODE_ADJUST) {
            
            displayTimeAdjust(COLOR_3);
            
            if (PLUS_GetValue() == 0) {
                // sw down
                if (_swPushPlus == 0) {
                    if (_swPushPlusTime > CHATTERING_TIME) {
                        // sw on
                        _swPushPlus = 2;
                        if (_timeAdjust < 127) {
                            _timeAdjust++;
                            saveTimeAdjust();
                        }
                    }
                } else if (_swPushPlus == 1) {
                    // sw up -> down
                    _swPushPlus = 0;
                    _swPushPlusTime = 0;
                }
            } else {
                // sw up
                _swPushPlus = 1;
            }            

            if (MINUS_GetValue() == 0) {
                // sw down
                if (_swPushMinus == 0) {
                    if (_swPushMinusTime > CHATTERING_TIME) {
                        // sw on
                        _swPushMinus = 2;
                        if (_timeAdjust > -128) {
                            _timeAdjust--;
                            saveTimeAdjust();
                        }
                    }
                } else if (_swPushMinus == 1) {
                    // sw up -> down
                    _swPushMinus = 0;
                    _swPushMinusTime = 0;
                }
            } else {
                // sw up
                _swPushMinus = 1;
            }            
            
        }

        vramInvalidate();
        
    }
}
/**
 End of File
*/