/**
  @Generated Pin Manager Header File

  @Company:
    Microchip Technology Inc.

  @File Name:
    pin_manager.h

  @Summary:
    This is the Pin Manager file generated using PIC10 / PIC12 / PIC16 / PIC18 MCUs

  @Description
    This header file provides APIs for driver for .
    Generation Information :
        Product Revision  :  PIC10 / PIC12 / PIC16 / PIC18 MCUs - 1.81.6
        Device            :  PIC16F18877
        Driver Version    :  2.11
    The generated drivers are tested against the following:
        Compiler          :  XC8 2.30 and above
        MPLAB 	          :  MPLAB X 5.40	
*/

/*
    (c) 2018 Microchip Technology Inc. and its subsidiaries. 
    
    Subject to your compliance with these terms, you may use Microchip software and any 
    derivatives exclusively with Microchip products. It is your responsibility to comply with third party 
    license terms applicable to your use of third party software (including open source software) that 
    may accompany Microchip software.
    
    THIS SOFTWARE IS SUPPLIED BY MICROCHIP "AS IS". NO WARRANTIES, WHETHER 
    EXPRESS, IMPLIED OR STATUTORY, APPLY TO THIS SOFTWARE, INCLUDING ANY 
    IMPLIED WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY, AND FITNESS 
    FOR A PARTICULAR PURPOSE.
    
    IN NO EVENT WILL MICROCHIP BE LIABLE FOR ANY INDIRECT, SPECIAL, PUNITIVE, 
    INCIDENTAL OR CONSEQUENTIAL LOSS, DAMAGE, COST OR EXPENSE OF ANY KIND 
    WHATSOEVER RELATED TO THE SOFTWARE, HOWEVER CAUSED, EVEN IF MICROCHIP 
    HAS BEEN ADVISED OF THE POSSIBILITY OR THE DAMAGES ARE FORESEEABLE. TO 
    THE FULLEST EXTENT ALLOWED BY LAW, MICROCHIP'S TOTAL LIABILITY ON ALL 
    CLAIMS IN ANY WAY RELATED TO THIS SOFTWARE WILL NOT EXCEED THE AMOUNT 
    OF FEES, IF ANY, THAT YOU HAVE PAID DIRECTLY TO MICROCHIP FOR THIS 
    SOFTWARE.
*/

#ifndef PIN_MANAGER_H
#define PIN_MANAGER_H

/**
  Section: Included Files
*/

#include <xc.h>

#define INPUT   1
#define OUTPUT  0

#define HIGH    1
#define LOW     0

#define ANALOG      1
#define DIGITAL     0

#define PULL_UP_ENABLED      1
#define PULL_UP_DISABLED     0

// get/set RA0 procedures
#define RA0_SetHigh()            do { LATAbits.LATA0 = 1; } while(0)
#define RA0_SetLow()             do { LATAbits.LATA0 = 0; } while(0)
#define RA0_Toggle()             do { LATAbits.LATA0 = ~LATAbits.LATA0; } while(0)
#define RA0_GetValue()              PORTAbits.RA0
#define RA0_SetDigitalInput()    do { TRISAbits.TRISA0 = 1; } while(0)
#define RA0_SetDigitalOutput()   do { TRISAbits.TRISA0 = 0; } while(0)
#define RA0_SetPullup()             do { WPUAbits.WPUA0 = 1; } while(0)
#define RA0_ResetPullup()           do { WPUAbits.WPUA0 = 0; } while(0)
#define RA0_SetAnalogMode()         do { ANSELAbits.ANSA0 = 1; } while(0)
#define RA0_SetDigitalMode()        do { ANSELAbits.ANSA0 = 0; } while(0)

// get/set RA1 procedures
#define RA1_SetHigh()            do { LATAbits.LATA1 = 1; } while(0)
#define RA1_SetLow()             do { LATAbits.LATA1 = 0; } while(0)
#define RA1_Toggle()             do { LATAbits.LATA1 = ~LATAbits.LATA1; } while(0)
#define RA1_GetValue()              PORTAbits.RA1
#define RA1_SetDigitalInput()    do { TRISAbits.TRISA1 = 1; } while(0)
#define RA1_SetDigitalOutput()   do { TRISAbits.TRISA1 = 0; } while(0)
#define RA1_SetPullup()             do { WPUAbits.WPUA1 = 1; } while(0)
#define RA1_ResetPullup()           do { WPUAbits.WPUA1 = 0; } while(0)
#define RA1_SetAnalogMode()         do { ANSELAbits.ANSA1 = 1; } while(0)
#define RA1_SetDigitalMode()        do { ANSELAbits.ANSA1 = 0; } while(0)

// get/set COL3A aliases
#define COL3A_TRIS                 TRISAbits.TRISA2
#define COL3A_LAT                  LATAbits.LATA2
#define COL3A_PORT                 PORTAbits.RA2
#define COL3A_WPU                  WPUAbits.WPUA2
#define COL3A_OD                   ODCONAbits.ODCA2
#define COL3A_ANS                  ANSELAbits.ANSA2
#define COL3A_SetHigh()            do { LATAbits.LATA2 = 1; } while(0)
#define COL3A_SetLow()             do { LATAbits.LATA2 = 0; } while(0)
#define COL3A_Toggle()             do { LATAbits.LATA2 = ~LATAbits.LATA2; } while(0)
#define COL3A_GetValue()           PORTAbits.RA2
#define COL3A_SetDigitalInput()    do { TRISAbits.TRISA2 = 1; } while(0)
#define COL3A_SetDigitalOutput()   do { TRISAbits.TRISA2 = 0; } while(0)
#define COL3A_SetPullup()          do { WPUAbits.WPUA2 = 1; } while(0)
#define COL3A_ResetPullup()        do { WPUAbits.WPUA2 = 0; } while(0)
#define COL3A_SetPushPull()        do { ODCONAbits.ODCA2 = 0; } while(0)
#define COL3A_SetOpenDrain()       do { ODCONAbits.ODCA2 = 1; } while(0)
#define COL3A_SetAnalogMode()      do { ANSELAbits.ANSA2 = 1; } while(0)
#define COL3A_SetDigitalMode()     do { ANSELAbits.ANSA2 = 0; } while(0)

// get/set RA3 procedures
#define RA3_SetHigh()            do { LATAbits.LATA3 = 1; } while(0)
#define RA3_SetLow()             do { LATAbits.LATA3 = 0; } while(0)
#define RA3_Toggle()             do { LATAbits.LATA3 = ~LATAbits.LATA3; } while(0)
#define RA3_GetValue()              PORTAbits.RA3
#define RA3_SetDigitalInput()    do { TRISAbits.TRISA3 = 1; } while(0)
#define RA3_SetDigitalOutput()   do { TRISAbits.TRISA3 = 0; } while(0)
#define RA3_SetPullup()             do { WPUAbits.WPUA3 = 1; } while(0)
#define RA3_ResetPullup()           do { WPUAbits.WPUA3 = 0; } while(0)
#define RA3_SetAnalogMode()         do { ANSELAbits.ANSA3 = 1; } while(0)
#define RA3_SetDigitalMode()        do { ANSELAbits.ANSA3 = 0; } while(0)

// get/set RA4 procedures
#define RA4_SetHigh()            do { LATAbits.LATA4 = 1; } while(0)
#define RA4_SetLow()             do { LATAbits.LATA4 = 0; } while(0)
#define RA4_Toggle()             do { LATAbits.LATA4 = ~LATAbits.LATA4; } while(0)
#define RA4_GetValue()              PORTAbits.RA4
#define RA4_SetDigitalInput()    do { TRISAbits.TRISA4 = 1; } while(0)
#define RA4_SetDigitalOutput()   do { TRISAbits.TRISA4 = 0; } while(0)
#define RA4_SetPullup()             do { WPUAbits.WPUA4 = 1; } while(0)
#define RA4_ResetPullup()           do { WPUAbits.WPUA4 = 0; } while(0)
#define RA4_SetAnalogMode()         do { ANSELAbits.ANSA4 = 1; } while(0)
#define RA4_SetDigitalMode()        do { ANSELAbits.ANSA4 = 0; } while(0)

// get/set RA5 procedures
#define RA5_SetHigh()            do { LATAbits.LATA5 = 1; } while(0)
#define RA5_SetLow()             do { LATAbits.LATA5 = 0; } while(0)
#define RA5_Toggle()             do { LATAbits.LATA5 = ~LATAbits.LATA5; } while(0)
#define RA5_GetValue()              PORTAbits.RA5
#define RA5_SetDigitalInput()    do { TRISAbits.TRISA5 = 1; } while(0)
#define RA5_SetDigitalOutput()   do { TRISAbits.TRISA5 = 0; } while(0)
#define RA5_SetPullup()             do { WPUAbits.WPUA5 = 1; } while(0)
#define RA5_ResetPullup()           do { WPUAbits.WPUA5 = 0; } while(0)
#define RA5_SetAnalogMode()         do { ANSELAbits.ANSA5 = 1; } while(0)
#define RA5_SetDigitalMode()        do { ANSELAbits.ANSA5 = 0; } while(0)

// get/set RA6 procedures
#define RA6_SetHigh()            do { LATAbits.LATA6 = 1; } while(0)
#define RA6_SetLow()             do { LATAbits.LATA6 = 0; } while(0)
#define RA6_Toggle()             do { LATAbits.LATA6 = ~LATAbits.LATA6; } while(0)
#define RA6_GetValue()              PORTAbits.RA6
#define RA6_SetDigitalInput()    do { TRISAbits.TRISA6 = 1; } while(0)
#define RA6_SetDigitalOutput()   do { TRISAbits.TRISA6 = 0; } while(0)
#define RA6_SetPullup()             do { WPUAbits.WPUA6 = 1; } while(0)
#define RA6_ResetPullup()           do { WPUAbits.WPUA6 = 0; } while(0)
#define RA6_SetAnalogMode()         do { ANSELAbits.ANSA6 = 1; } while(0)
#define RA6_SetDigitalMode()        do { ANSELAbits.ANSA6 = 0; } while(0)

// get/set RA7 procedures
#define RA7_SetHigh()            do { LATAbits.LATA7 = 1; } while(0)
#define RA7_SetLow()             do { LATAbits.LATA7 = 0; } while(0)
#define RA7_Toggle()             do { LATAbits.LATA7 = ~LATAbits.LATA7; } while(0)
#define RA7_GetValue()              PORTAbits.RA7
#define RA7_SetDigitalInput()    do { TRISAbits.TRISA7 = 1; } while(0)
#define RA7_SetDigitalOutput()   do { TRISAbits.TRISA7 = 0; } while(0)
#define RA7_SetPullup()             do { WPUAbits.WPUA7 = 1; } while(0)
#define RA7_ResetPullup()           do { WPUAbits.WPUA7 = 0; } while(0)
#define RA7_SetAnalogMode()         do { ANSELAbits.ANSA7 = 1; } while(0)
#define RA7_SetDigitalMode()        do { ANSELAbits.ANSA7 = 0; } while(0)

// get/set VIBRATION aliases
#define VIBRATION_TRIS                 TRISBbits.TRISB0
#define VIBRATION_LAT                  LATBbits.LATB0
#define VIBRATION_PORT                 PORTBbits.RB0
#define VIBRATION_WPU                  WPUBbits.WPUB0
#define VIBRATION_OD                   ODCONBbits.ODCB0
#define VIBRATION_ANS                  ANSELBbits.ANSB0
#define VIBRATION_SetHigh()            do { LATBbits.LATB0 = 1; } while(0)
#define VIBRATION_SetLow()             do { LATBbits.LATB0 = 0; } while(0)
#define VIBRATION_Toggle()             do { LATBbits.LATB0 = ~LATBbits.LATB0; } while(0)
#define VIBRATION_GetValue()           PORTBbits.RB0
#define VIBRATION_SetDigitalInput()    do { TRISBbits.TRISB0 = 1; } while(0)
#define VIBRATION_SetDigitalOutput()   do { TRISBbits.TRISB0 = 0; } while(0)
#define VIBRATION_SetPullup()          do { WPUBbits.WPUB0 = 1; } while(0)
#define VIBRATION_ResetPullup()        do { WPUBbits.WPUB0 = 0; } while(0)
#define VIBRATION_SetPushPull()        do { ODCONBbits.ODCB0 = 0; } while(0)
#define VIBRATION_SetOpenDrain()       do { ODCONBbits.ODCB0 = 1; } while(0)
#define VIBRATION_SetAnalogMode()      do { ANSELBbits.ANSB0 = 1; } while(0)
#define VIBRATION_SetDigitalMode()     do { ANSELBbits.ANSB0 = 0; } while(0)

// get/set COL8A aliases
#define COL8A_TRIS                 TRISBbits.TRISB1
#define COL8A_LAT                  LATBbits.LATB1
#define COL8A_PORT                 PORTBbits.RB1
#define COL8A_WPU                  WPUBbits.WPUB1
#define COL8A_OD                   ODCONBbits.ODCB1
#define COL8A_ANS                  ANSELBbits.ANSB1
#define COL8A_SetHigh()            do { LATBbits.LATB1 = 1; } while(0)
#define COL8A_SetLow()             do { LATBbits.LATB1 = 0; } while(0)
#define COL8A_Toggle()             do { LATBbits.LATB1 = ~LATBbits.LATB1; } while(0)
#define COL8A_GetValue()           PORTBbits.RB1
#define COL8A_SetDigitalInput()    do { TRISBbits.TRISB1 = 1; } while(0)
#define COL8A_SetDigitalOutput()   do { TRISBbits.TRISB1 = 0; } while(0)
#define COL8A_SetPullup()          do { WPUBbits.WPUB1 = 1; } while(0)
#define COL8A_ResetPullup()        do { WPUBbits.WPUB1 = 0; } while(0)
#define COL8A_SetPushPull()        do { ODCONBbits.ODCB1 = 0; } while(0)
#define COL8A_SetOpenDrain()       do { ODCONBbits.ODCB1 = 1; } while(0)
#define COL8A_SetAnalogMode()      do { ANSELBbits.ANSB1 = 1; } while(0)
#define COL8A_SetDigitalMode()     do { ANSELBbits.ANSB1 = 0; } while(0)

// get/set COL7A aliases
#define COL7A_TRIS                 TRISBbits.TRISB2
#define COL7A_LAT                  LATBbits.LATB2
#define COL7A_PORT                 PORTBbits.RB2
#define COL7A_WPU                  WPUBbits.WPUB2
#define COL7A_OD                   ODCONBbits.ODCB2
#define COL7A_ANS                  ANSELBbits.ANSB2
#define COL7A_SetHigh()            do { LATBbits.LATB2 = 1; } while(0)
#define COL7A_SetLow()             do { LATBbits.LATB2 = 0; } while(0)
#define COL7A_Toggle()             do { LATBbits.LATB2 = ~LATBbits.LATB2; } while(0)
#define COL7A_GetValue()           PORTBbits.RB2
#define COL7A_SetDigitalInput()    do { TRISBbits.TRISB2 = 1; } while(0)
#define COL7A_SetDigitalOutput()   do { TRISBbits.TRISB2 = 0; } while(0)
#define COL7A_SetPullup()          do { WPUBbits.WPUB2 = 1; } while(0)
#define COL7A_ResetPullup()        do { WPUBbits.WPUB2 = 0; } while(0)
#define COL7A_SetPushPull()        do { ODCONBbits.ODCB2 = 0; } while(0)
#define COL7A_SetOpenDrain()       do { ODCONBbits.ODCB2 = 1; } while(0)
#define COL7A_SetAnalogMode()      do { ANSELBbits.ANSB2 = 1; } while(0)
#define COL7A_SetDigitalMode()     do { ANSELBbits.ANSB2 = 0; } while(0)

// get/set COL4A aliases
#define COL4A_TRIS                 TRISBbits.TRISB3
#define COL4A_LAT                  LATBbits.LATB3
#define COL4A_PORT                 PORTBbits.RB3
#define COL4A_WPU                  WPUBbits.WPUB3
#define COL4A_OD                   ODCONBbits.ODCB3
#define COL4A_ANS                  ANSELBbits.ANSB3
#define COL4A_SetHigh()            do { LATBbits.LATB3 = 1; } while(0)
#define COL4A_SetLow()             do { LATBbits.LATB3 = 0; } while(0)
#define COL4A_Toggle()             do { LATBbits.LATB3 = ~LATBbits.LATB3; } while(0)
#define COL4A_GetValue()           PORTBbits.RB3
#define COL4A_SetDigitalInput()    do { TRISBbits.TRISB3 = 1; } while(0)
#define COL4A_SetDigitalOutput()   do { TRISBbits.TRISB3 = 0; } while(0)
#define COL4A_SetPullup()          do { WPUBbits.WPUB3 = 1; } while(0)
#define COL4A_ResetPullup()        do { WPUBbits.WPUB3 = 0; } while(0)
#define COL4A_SetPushPull()        do { ODCONBbits.ODCB3 = 0; } while(0)
#define COL4A_SetOpenDrain()       do { ODCONBbits.ODCB3 = 1; } while(0)
#define COL4A_SetAnalogMode()      do { ANSELBbits.ANSB3 = 1; } while(0)
#define COL4A_SetDigitalMode()     do { ANSELBbits.ANSB3 = 0; } while(0)

// get/set COL6A aliases
#define COL6A_TRIS                 TRISBbits.TRISB4
#define COL6A_LAT                  LATBbits.LATB4
#define COL6A_PORT                 PORTBbits.RB4
#define COL6A_WPU                  WPUBbits.WPUB4
#define COL6A_OD                   ODCONBbits.ODCB4
#define COL6A_ANS                  ANSELBbits.ANSB4
#define COL6A_SetHigh()            do { LATBbits.LATB4 = 1; } while(0)
#define COL6A_SetLow()             do { LATBbits.LATB4 = 0; } while(0)
#define COL6A_Toggle()             do { LATBbits.LATB4 = ~LATBbits.LATB4; } while(0)
#define COL6A_GetValue()           PORTBbits.RB4
#define COL6A_SetDigitalInput()    do { TRISBbits.TRISB4 = 1; } while(0)
#define COL6A_SetDigitalOutput()   do { TRISBbits.TRISB4 = 0; } while(0)
#define COL6A_SetPullup()          do { WPUBbits.WPUB4 = 1; } while(0)
#define COL6A_ResetPullup()        do { WPUBbits.WPUB4 = 0; } while(0)
#define COL6A_SetPushPull()        do { ODCONBbits.ODCB4 = 0; } while(0)
#define COL6A_SetOpenDrain()       do { ODCONBbits.ODCB4 = 1; } while(0)
#define COL6A_SetAnalogMode()      do { ANSELBbits.ANSB4 = 1; } while(0)
#define COL6A_SetDigitalMode()     do { ANSELBbits.ANSB4 = 0; } while(0)

// get/set COL1A aliases
#define COL1A_TRIS                 TRISBbits.TRISB5
#define COL1A_LAT                  LATBbits.LATB5
#define COL1A_PORT                 PORTBbits.RB5
#define COL1A_WPU                  WPUBbits.WPUB5
#define COL1A_OD                   ODCONBbits.ODCB5
#define COL1A_ANS                  ANSELBbits.ANSB5
#define COL1A_SetHigh()            do { LATBbits.LATB5 = 1; } while(0)
#define COL1A_SetLow()             do { LATBbits.LATB5 = 0; } while(0)
#define COL1A_Toggle()             do { LATBbits.LATB5 = ~LATBbits.LATB5; } while(0)
#define COL1A_GetValue()           PORTBbits.RB5
#define COL1A_SetDigitalInput()    do { TRISBbits.TRISB5 = 1; } while(0)
#define COL1A_SetDigitalOutput()   do { TRISBbits.TRISB5 = 0; } while(0)
#define COL1A_SetPullup()          do { WPUBbits.WPUB5 = 1; } while(0)
#define COL1A_ResetPullup()        do { WPUBbits.WPUB5 = 0; } while(0)
#define COL1A_SetPushPull()        do { ODCONBbits.ODCB5 = 0; } while(0)
#define COL1A_SetOpenDrain()       do { ODCONBbits.ODCB5 = 1; } while(0)
#define COL1A_SetAnalogMode()      do { ANSELBbits.ANSB5 = 1; } while(0)
#define COL1A_SetDigitalMode()     do { ANSELBbits.ANSB5 = 0; } while(0)

// get/set PLUS aliases
#define PLUS_TRIS                 TRISBbits.TRISB6
#define PLUS_LAT                  LATBbits.LATB6
#define PLUS_PORT                 PORTBbits.RB6
#define PLUS_WPU                  WPUBbits.WPUB6
#define PLUS_OD                   ODCONBbits.ODCB6
#define PLUS_ANS                  ANSELBbits.ANSB6
#define PLUS_SetHigh()            do { LATBbits.LATB6 = 1; } while(0)
#define PLUS_SetLow()             do { LATBbits.LATB6 = 0; } while(0)
#define PLUS_Toggle()             do { LATBbits.LATB6 = ~LATBbits.LATB6; } while(0)
#define PLUS_GetValue()           PORTBbits.RB6
#define PLUS_SetDigitalInput()    do { TRISBbits.TRISB6 = 1; } while(0)
#define PLUS_SetDigitalOutput()   do { TRISBbits.TRISB6 = 0; } while(0)
#define PLUS_SetPullup()          do { WPUBbits.WPUB6 = 1; } while(0)
#define PLUS_ResetPullup()        do { WPUBbits.WPUB6 = 0; } while(0)
#define PLUS_SetPushPull()        do { ODCONBbits.ODCB6 = 0; } while(0)
#define PLUS_SetOpenDrain()       do { ODCONBbits.ODCB6 = 1; } while(0)
#define PLUS_SetAnalogMode()      do { ANSELBbits.ANSB6 = 1; } while(0)
#define PLUS_SetDigitalMode()     do { ANSELBbits.ANSB6 = 0; } while(0)

// get/set MINUS aliases
#define MINUS_TRIS                 TRISBbits.TRISB7
#define MINUS_LAT                  LATBbits.LATB7
#define MINUS_PORT                 PORTBbits.RB7
#define MINUS_WPU                  WPUBbits.WPUB7
#define MINUS_OD                   ODCONBbits.ODCB7
#define MINUS_ANS                  ANSELBbits.ANSB7
#define MINUS_SetHigh()            do { LATBbits.LATB7 = 1; } while(0)
#define MINUS_SetLow()             do { LATBbits.LATB7 = 0; } while(0)
#define MINUS_Toggle()             do { LATBbits.LATB7 = ~LATBbits.LATB7; } while(0)
#define MINUS_GetValue()           PORTBbits.RB7
#define MINUS_SetDigitalInput()    do { TRISBbits.TRISB7 = 1; } while(0)
#define MINUS_SetDigitalOutput()   do { TRISBbits.TRISB7 = 0; } while(0)
#define MINUS_SetPullup()          do { WPUBbits.WPUB7 = 1; } while(0)
#define MINUS_ResetPullup()        do { WPUBbits.WPUB7 = 0; } while(0)
#define MINUS_SetPushPull()        do { ODCONBbits.ODCB7 = 0; } while(0)
#define MINUS_SetOpenDrain()       do { ODCONBbits.ODCB7 = 1; } while(0)
#define MINUS_SetAnalogMode()      do { ANSELBbits.ANSB7 = 1; } while(0)
#define MINUS_SetDigitalMode()     do { ANSELBbits.ANSB7 = 0; } while(0)

// get/set COL3B aliases
#define COL3B_TRIS                 TRISCbits.TRISC0
#define COL3B_LAT                  LATCbits.LATC0
#define COL3B_PORT                 PORTCbits.RC0
#define COL3B_WPU                  WPUCbits.WPUC0
#define COL3B_OD                   ODCONCbits.ODCC0
#define COL3B_ANS                  ANSELCbits.ANSC0
#define COL3B_SetHigh()            do { LATCbits.LATC0 = 1; } while(0)
#define COL3B_SetLow()             do { LATCbits.LATC0 = 0; } while(0)
#define COL3B_Toggle()             do { LATCbits.LATC0 = ~LATCbits.LATC0; } while(0)
#define COL3B_GetValue()           PORTCbits.RC0
#define COL3B_SetDigitalInput()    do { TRISCbits.TRISC0 = 1; } while(0)
#define COL3B_SetDigitalOutput()   do { TRISCbits.TRISC0 = 0; } while(0)
#define COL3B_SetPullup()          do { WPUCbits.WPUC0 = 1; } while(0)
#define COL3B_ResetPullup()        do { WPUCbits.WPUC0 = 0; } while(0)
#define COL3B_SetPushPull()        do { ODCONCbits.ODCC0 = 0; } while(0)
#define COL3B_SetOpenDrain()       do { ODCONCbits.ODCC0 = 1; } while(0)
#define COL3B_SetAnalogMode()      do { ANSELCbits.ANSC0 = 1; } while(0)
#define COL3B_SetDigitalMode()     do { ANSELCbits.ANSC0 = 0; } while(0)

// get/set RC1 procedures
#define RC1_SetHigh()            do { LATCbits.LATC1 = 1; } while(0)
#define RC1_SetLow()             do { LATCbits.LATC1 = 0; } while(0)
#define RC1_Toggle()             do { LATCbits.LATC1 = ~LATCbits.LATC1; } while(0)
#define RC1_GetValue()              PORTCbits.RC1
#define RC1_SetDigitalInput()    do { TRISCbits.TRISC1 = 1; } while(0)
#define RC1_SetDigitalOutput()   do { TRISCbits.TRISC1 = 0; } while(0)
#define RC1_SetPullup()             do { WPUCbits.WPUC1 = 1; } while(0)
#define RC1_ResetPullup()           do { WPUCbits.WPUC1 = 0; } while(0)
#define RC1_SetAnalogMode()         do { ANSELCbits.ANSC1 = 1; } while(0)
#define RC1_SetDigitalMode()        do { ANSELCbits.ANSC1 = 0; } while(0)

// get/set COL5B aliases
#define COL5B_TRIS                 TRISCbits.TRISC2
#define COL5B_LAT                  LATCbits.LATC2
#define COL5B_PORT                 PORTCbits.RC2
#define COL5B_WPU                  WPUCbits.WPUC2
#define COL5B_OD                   ODCONCbits.ODCC2
#define COL5B_ANS                  ANSELCbits.ANSC2
#define COL5B_SetHigh()            do { LATCbits.LATC2 = 1; } while(0)
#define COL5B_SetLow()             do { LATCbits.LATC2 = 0; } while(0)
#define COL5B_Toggle()             do { LATCbits.LATC2 = ~LATCbits.LATC2; } while(0)
#define COL5B_GetValue()           PORTCbits.RC2
#define COL5B_SetDigitalInput()    do { TRISCbits.TRISC2 = 1; } while(0)
#define COL5B_SetDigitalOutput()   do { TRISCbits.TRISC2 = 0; } while(0)
#define COL5B_SetPullup()          do { WPUCbits.WPUC2 = 1; } while(0)
#define COL5B_ResetPullup()        do { WPUCbits.WPUC2 = 0; } while(0)
#define COL5B_SetPushPull()        do { ODCONCbits.ODCC2 = 0; } while(0)
#define COL5B_SetOpenDrain()       do { ODCONCbits.ODCC2 = 1; } while(0)
#define COL5B_SetAnalogMode()      do { ANSELCbits.ANSC2 = 1; } while(0)
#define COL5B_SetDigitalMode()     do { ANSELCbits.ANSC2 = 0; } while(0)

// get/set RC3 procedures
#define RC3_SetHigh()            do { LATCbits.LATC3 = 1; } while(0)
#define RC3_SetLow()             do { LATCbits.LATC3 = 0; } while(0)
#define RC3_Toggle()             do { LATCbits.LATC3 = ~LATCbits.LATC3; } while(0)
#define RC3_GetValue()              PORTCbits.RC3
#define RC3_SetDigitalInput()    do { TRISCbits.TRISC3 = 1; } while(0)
#define RC3_SetDigitalOutput()   do { TRISCbits.TRISC3 = 0; } while(0)
#define RC3_SetPullup()             do { WPUCbits.WPUC3 = 1; } while(0)
#define RC3_ResetPullup()           do { WPUCbits.WPUC3 = 0; } while(0)
#define RC3_SetAnalogMode()         do { ANSELCbits.ANSC3 = 1; } while(0)
#define RC3_SetDigitalMode()        do { ANSELCbits.ANSC3 = 0; } while(0)

// get/set RC4 procedures
#define RC4_SetHigh()            do { LATCbits.LATC4 = 1; } while(0)
#define RC4_SetLow()             do { LATCbits.LATC4 = 0; } while(0)
#define RC4_Toggle()             do { LATCbits.LATC4 = ~LATCbits.LATC4; } while(0)
#define RC4_GetValue()              PORTCbits.RC4
#define RC4_SetDigitalInput()    do { TRISCbits.TRISC4 = 1; } while(0)
#define RC4_SetDigitalOutput()   do { TRISCbits.TRISC4 = 0; } while(0)
#define RC4_SetPullup()             do { WPUCbits.WPUC4 = 1; } while(0)
#define RC4_ResetPullup()           do { WPUCbits.WPUC4 = 0; } while(0)
#define RC4_SetAnalogMode()         do { ANSELCbits.ANSC4 = 1; } while(0)
#define RC4_SetDigitalMode()        do { ANSELCbits.ANSC4 = 0; } while(0)

// get/set COL1B aliases
#define COL1B_TRIS                 TRISCbits.TRISC5
#define COL1B_LAT                  LATCbits.LATC5
#define COL1B_PORT                 PORTCbits.RC5
#define COL1B_WPU                  WPUCbits.WPUC5
#define COL1B_OD                   ODCONCbits.ODCC5
#define COL1B_ANS                  ANSELCbits.ANSC5
#define COL1B_SetHigh()            do { LATCbits.LATC5 = 1; } while(0)
#define COL1B_SetLow()             do { LATCbits.LATC5 = 0; } while(0)
#define COL1B_Toggle()             do { LATCbits.LATC5 = ~LATCbits.LATC5; } while(0)
#define COL1B_GetValue()           PORTCbits.RC5
#define COL1B_SetDigitalInput()    do { TRISCbits.TRISC5 = 1; } while(0)
#define COL1B_SetDigitalOutput()   do { TRISCbits.TRISC5 = 0; } while(0)
#define COL1B_SetPullup()          do { WPUCbits.WPUC5 = 1; } while(0)
#define COL1B_ResetPullup()        do { WPUCbits.WPUC5 = 0; } while(0)
#define COL1B_SetPushPull()        do { ODCONCbits.ODCC5 = 0; } while(0)
#define COL1B_SetOpenDrain()       do { ODCONCbits.ODCC5 = 1; } while(0)
#define COL1B_SetAnalogMode()      do { ANSELCbits.ANSC5 = 1; } while(0)
#define COL1B_SetDigitalMode()     do { ANSELCbits.ANSC5 = 0; } while(0)

// get/set RC6 procedures
#define RC6_SetHigh()            do { LATCbits.LATC6 = 1; } while(0)
#define RC6_SetLow()             do { LATCbits.LATC6 = 0; } while(0)
#define RC6_Toggle()             do { LATCbits.LATC6 = ~LATCbits.LATC6; } while(0)
#define RC6_GetValue()              PORTCbits.RC6
#define RC6_SetDigitalInput()    do { TRISCbits.TRISC6 = 1; } while(0)
#define RC6_SetDigitalOutput()   do { TRISCbits.TRISC6 = 0; } while(0)
#define RC6_SetPullup()             do { WPUCbits.WPUC6 = 1; } while(0)
#define RC6_ResetPullup()           do { WPUCbits.WPUC6 = 0; } while(0)
#define RC6_SetAnalogMode()         do { ANSELCbits.ANSC6 = 1; } while(0)
#define RC6_SetDigitalMode()        do { ANSELCbits.ANSC6 = 0; } while(0)

// get/set COL7B aliases
#define COL7B_TRIS                 TRISCbits.TRISC7
#define COL7B_LAT                  LATCbits.LATC7
#define COL7B_PORT                 PORTCbits.RC7
#define COL7B_WPU                  WPUCbits.WPUC7
#define COL7B_OD                   ODCONCbits.ODCC7
#define COL7B_ANS                  ANSELCbits.ANSC7
#define COL7B_SetHigh()            do { LATCbits.LATC7 = 1; } while(0)
#define COL7B_SetLow()             do { LATCbits.LATC7 = 0; } while(0)
#define COL7B_Toggle()             do { LATCbits.LATC7 = ~LATCbits.LATC7; } while(0)
#define COL7B_GetValue()           PORTCbits.RC7
#define COL7B_SetDigitalInput()    do { TRISCbits.TRISC7 = 1; } while(0)
#define COL7B_SetDigitalOutput()   do { TRISCbits.TRISC7 = 0; } while(0)
#define COL7B_SetPullup()          do { WPUCbits.WPUC7 = 1; } while(0)
#define COL7B_ResetPullup()        do { WPUCbits.WPUC7 = 0; } while(0)
#define COL7B_SetPushPull()        do { ODCONCbits.ODCC7 = 0; } while(0)
#define COL7B_SetOpenDrain()       do { ODCONCbits.ODCC7 = 1; } while(0)
#define COL7B_SetAnalogMode()      do { ANSELCbits.ANSC7 = 1; } while(0)
#define COL7B_SetDigitalMode()     do { ANSELCbits.ANSC7 = 0; } while(0)

// get/set RD0 procedures
#define RD0_SetHigh()            do { LATDbits.LATD0 = 1; } while(0)
#define RD0_SetLow()             do { LATDbits.LATD0 = 0; } while(0)
#define RD0_Toggle()             do { LATDbits.LATD0 = ~LATDbits.LATD0; } while(0)
#define RD0_GetValue()              PORTDbits.RD0
#define RD0_SetDigitalInput()    do { TRISDbits.TRISD0 = 1; } while(0)
#define RD0_SetDigitalOutput()   do { TRISDbits.TRISD0 = 0; } while(0)
#define RD0_SetPullup()             do { WPUDbits.WPUD0 = 1; } while(0)
#define RD0_ResetPullup()           do { WPUDbits.WPUD0 = 0; } while(0)
#define RD0_SetAnalogMode()         do { ANSELDbits.ANSD0 = 1; } while(0)
#define RD0_SetDigitalMode()        do { ANSELDbits.ANSD0 = 0; } while(0)

// get/set RD1 procedures
#define RD1_SetHigh()            do { LATDbits.LATD1 = 1; } while(0)
#define RD1_SetLow()             do { LATDbits.LATD1 = 0; } while(0)
#define RD1_Toggle()             do { LATDbits.LATD1 = ~LATDbits.LATD1; } while(0)
#define RD1_GetValue()              PORTDbits.RD1
#define RD1_SetDigitalInput()    do { TRISDbits.TRISD1 = 1; } while(0)
#define RD1_SetDigitalOutput()   do { TRISDbits.TRISD1 = 0; } while(0)
#define RD1_SetPullup()             do { WPUDbits.WPUD1 = 1; } while(0)
#define RD1_ResetPullup()           do { WPUDbits.WPUD1 = 0; } while(0)
#define RD1_SetAnalogMode()         do { ANSELDbits.ANSD1 = 1; } while(0)
#define RD1_SetDigitalMode()        do { ANSELDbits.ANSD1 = 0; } while(0)

// get/set COL4B aliases
#define COL4B_TRIS                 TRISDbits.TRISD2
#define COL4B_LAT                  LATDbits.LATD2
#define COL4B_PORT                 PORTDbits.RD2
#define COL4B_WPU                  WPUDbits.WPUD2
#define COL4B_OD                   ODCONDbits.ODCD2
#define COL4B_ANS                  ANSELDbits.ANSD2
#define COL4B_SetHigh()            do { LATDbits.LATD2 = 1; } while(0)
#define COL4B_SetLow()             do { LATDbits.LATD2 = 0; } while(0)
#define COL4B_Toggle()             do { LATDbits.LATD2 = ~LATDbits.LATD2; } while(0)
#define COL4B_GetValue()           PORTDbits.RD2
#define COL4B_SetDigitalInput()    do { TRISDbits.TRISD2 = 1; } while(0)
#define COL4B_SetDigitalOutput()   do { TRISDbits.TRISD2 = 0; } while(0)
#define COL4B_SetPullup()          do { WPUDbits.WPUD2 = 1; } while(0)
#define COL4B_ResetPullup()        do { WPUDbits.WPUD2 = 0; } while(0)
#define COL4B_SetPushPull()        do { ODCONDbits.ODCD2 = 0; } while(0)
#define COL4B_SetOpenDrain()       do { ODCONDbits.ODCD2 = 1; } while(0)
#define COL4B_SetAnalogMode()      do { ANSELDbits.ANSD2 = 1; } while(0)
#define COL4B_SetDigitalMode()     do { ANSELDbits.ANSD2 = 0; } while(0)

// get/set COL6B aliases
#define COL6B_TRIS                 TRISDbits.TRISD3
#define COL6B_LAT                  LATDbits.LATD3
#define COL6B_PORT                 PORTDbits.RD3
#define COL6B_WPU                  WPUDbits.WPUD3
#define COL6B_OD                   ODCONDbits.ODCD3
#define COL6B_ANS                  ANSELDbits.ANSD3
#define COL6B_SetHigh()            do { LATDbits.LATD3 = 1; } while(0)
#define COL6B_SetLow()             do { LATDbits.LATD3 = 0; } while(0)
#define COL6B_Toggle()             do { LATDbits.LATD3 = ~LATDbits.LATD3; } while(0)
#define COL6B_GetValue()           PORTDbits.RD3
#define COL6B_SetDigitalInput()    do { TRISDbits.TRISD3 = 1; } while(0)
#define COL6B_SetDigitalOutput()   do { TRISDbits.TRISD3 = 0; } while(0)
#define COL6B_SetPullup()          do { WPUDbits.WPUD3 = 1; } while(0)
#define COL6B_ResetPullup()        do { WPUDbits.WPUD3 = 0; } while(0)
#define COL6B_SetPushPull()        do { ODCONDbits.ODCD3 = 0; } while(0)
#define COL6B_SetOpenDrain()       do { ODCONDbits.ODCD3 = 1; } while(0)
#define COL6B_SetAnalogMode()      do { ANSELDbits.ANSD3 = 1; } while(0)
#define COL6B_SetDigitalMode()     do { ANSELDbits.ANSD3 = 0; } while(0)

// get/set COL8B aliases
#define COL8B_TRIS                 TRISDbits.TRISD4
#define COL8B_LAT                  LATDbits.LATD4
#define COL8B_PORT                 PORTDbits.RD4
#define COL8B_WPU                  WPUDbits.WPUD4
#define COL8B_OD                   ODCONDbits.ODCD4
#define COL8B_ANS                  ANSELDbits.ANSD4
#define COL8B_SetHigh()            do { LATDbits.LATD4 = 1; } while(0)
#define COL8B_SetLow()             do { LATDbits.LATD4 = 0; } while(0)
#define COL8B_Toggle()             do { LATDbits.LATD4 = ~LATDbits.LATD4; } while(0)
#define COL8B_GetValue()           PORTDbits.RD4
#define COL8B_SetDigitalInput()    do { TRISDbits.TRISD4 = 1; } while(0)
#define COL8B_SetDigitalOutput()   do { TRISDbits.TRISD4 = 0; } while(0)
#define COL8B_SetPullup()          do { WPUDbits.WPUD4 = 1; } while(0)
#define COL8B_ResetPullup()        do { WPUDbits.WPUD4 = 0; } while(0)
#define COL8B_SetPushPull()        do { ODCONDbits.ODCD4 = 0; } while(0)
#define COL8B_SetOpenDrain()       do { ODCONDbits.ODCD4 = 1; } while(0)
#define COL8B_SetAnalogMode()      do { ANSELDbits.ANSD4 = 1; } while(0)
#define COL8B_SetDigitalMode()     do { ANSELDbits.ANSD4 = 0; } while(0)

// get/set RD5 procedures
#define RD5_SetHigh()            do { LATDbits.LATD5 = 1; } while(0)
#define RD5_SetLow()             do { LATDbits.LATD5 = 0; } while(0)
#define RD5_Toggle()             do { LATDbits.LATD5 = ~LATDbits.LATD5; } while(0)
#define RD5_GetValue()              PORTDbits.RD5
#define RD5_SetDigitalInput()    do { TRISDbits.TRISD5 = 1; } while(0)
#define RD5_SetDigitalOutput()   do { TRISDbits.TRISD5 = 0; } while(0)
#define RD5_SetPullup()             do { WPUDbits.WPUD5 = 1; } while(0)
#define RD5_ResetPullup()           do { WPUDbits.WPUD5 = 0; } while(0)
#define RD5_SetAnalogMode()         do { ANSELDbits.ANSD5 = 1; } while(0)
#define RD5_SetDigitalMode()        do { ANSELDbits.ANSD5 = 0; } while(0)

// get/set RD6 procedures
#define RD6_SetHigh()            do { LATDbits.LATD6 = 1; } while(0)
#define RD6_SetLow()             do { LATDbits.LATD6 = 0; } while(0)
#define RD6_Toggle()             do { LATDbits.LATD6 = ~LATDbits.LATD6; } while(0)
#define RD6_GetValue()              PORTDbits.RD6
#define RD6_SetDigitalInput()    do { TRISDbits.TRISD6 = 1; } while(0)
#define RD6_SetDigitalOutput()   do { TRISDbits.TRISD6 = 0; } while(0)
#define RD6_SetPullup()             do { WPUDbits.WPUD6 = 1; } while(0)
#define RD6_ResetPullup()           do { WPUDbits.WPUD6 = 0; } while(0)
#define RD6_SetAnalogMode()         do { ANSELDbits.ANSD6 = 1; } while(0)
#define RD6_SetDigitalMode()        do { ANSELDbits.ANSD6 = 0; } while(0)

// get/set RD7 procedures
#define RD7_SetHigh()            do { LATDbits.LATD7 = 1; } while(0)
#define RD7_SetLow()             do { LATDbits.LATD7 = 0; } while(0)
#define RD7_Toggle()             do { LATDbits.LATD7 = ~LATDbits.LATD7; } while(0)
#define RD7_GetValue()              PORTDbits.RD7
#define RD7_SetDigitalInput()    do { TRISDbits.TRISD7 = 1; } while(0)
#define RD7_SetDigitalOutput()   do { TRISDbits.TRISD7 = 0; } while(0)
#define RD7_SetPullup()             do { WPUDbits.WPUD7 = 1; } while(0)
#define RD7_ResetPullup()           do { WPUDbits.WPUD7 = 0; } while(0)
#define RD7_SetAnalogMode()         do { ANSELDbits.ANSD7 = 1; } while(0)
#define RD7_SetDigitalMode()        do { ANSELDbits.ANSD7 = 0; } while(0)

// get/set COL5A aliases
#define COL5A_TRIS                 TRISEbits.TRISE0
#define COL5A_LAT                  LATEbits.LATE0
#define COL5A_PORT                 PORTEbits.RE0
#define COL5A_WPU                  WPUEbits.WPUE0
#define COL5A_OD                   ODCONEbits.ODCE0
#define COL5A_ANS                  ANSELEbits.ANSE0
#define COL5A_SetHigh()            do { LATEbits.LATE0 = 1; } while(0)
#define COL5A_SetLow()             do { LATEbits.LATE0 = 0; } while(0)
#define COL5A_Toggle()             do { LATEbits.LATE0 = ~LATEbits.LATE0; } while(0)
#define COL5A_GetValue()           PORTEbits.RE0
#define COL5A_SetDigitalInput()    do { TRISEbits.TRISE0 = 1; } while(0)
#define COL5A_SetDigitalOutput()   do { TRISEbits.TRISE0 = 0; } while(0)
#define COL5A_SetPullup()          do { WPUEbits.WPUE0 = 1; } while(0)
#define COL5A_ResetPullup()        do { WPUEbits.WPUE0 = 0; } while(0)
#define COL5A_SetPushPull()        do { ODCONEbits.ODCE0 = 0; } while(0)
#define COL5A_SetOpenDrain()       do { ODCONEbits.ODCE0 = 1; } while(0)
#define COL5A_SetAnalogMode()      do { ANSELEbits.ANSE0 = 1; } while(0)
#define COL5A_SetDigitalMode()     do { ANSELEbits.ANSE0 = 0; } while(0)

// get/set COL2A aliases
#define COL2A_TRIS                 TRISEbits.TRISE1
#define COL2A_LAT                  LATEbits.LATE1
#define COL2A_PORT                 PORTEbits.RE1
#define COL2A_WPU                  WPUEbits.WPUE1
#define COL2A_OD                   ODCONEbits.ODCE1
#define COL2A_ANS                  ANSELEbits.ANSE1
#define COL2A_SetHigh()            do { LATEbits.LATE1 = 1; } while(0)
#define COL2A_SetLow()             do { LATEbits.LATE1 = 0; } while(0)
#define COL2A_Toggle()             do { LATEbits.LATE1 = ~LATEbits.LATE1; } while(0)
#define COL2A_GetValue()           PORTEbits.RE1
#define COL2A_SetDigitalInput()    do { TRISEbits.TRISE1 = 1; } while(0)
#define COL2A_SetDigitalOutput()   do { TRISEbits.TRISE1 = 0; } while(0)
#define COL2A_SetPullup()          do { WPUEbits.WPUE1 = 1; } while(0)
#define COL2A_ResetPullup()        do { WPUEbits.WPUE1 = 0; } while(0)
#define COL2A_SetPushPull()        do { ODCONEbits.ODCE1 = 0; } while(0)
#define COL2A_SetOpenDrain()       do { ODCONEbits.ODCE1 = 1; } while(0)
#define COL2A_SetAnalogMode()      do { ANSELEbits.ANSE1 = 1; } while(0)
#define COL2A_SetDigitalMode()     do { ANSELEbits.ANSE1 = 0; } while(0)

// get/set COL2B aliases
#define COL2B_TRIS                 TRISEbits.TRISE2
#define COL2B_LAT                  LATEbits.LATE2
#define COL2B_PORT                 PORTEbits.RE2
#define COL2B_WPU                  WPUEbits.WPUE2
#define COL2B_OD                   ODCONEbits.ODCE2
#define COL2B_ANS                  ANSELEbits.ANSE2
#define COL2B_SetHigh()            do { LATEbits.LATE2 = 1; } while(0)
#define COL2B_SetLow()             do { LATEbits.LATE2 = 0; } while(0)
#define COL2B_Toggle()             do { LATEbits.LATE2 = ~LATEbits.LATE2; } while(0)
#define COL2B_GetValue()           PORTEbits.RE2
#define COL2B_SetDigitalInput()    do { TRISEbits.TRISE2 = 1; } while(0)
#define COL2B_SetDigitalOutput()   do { TRISEbits.TRISE2 = 0; } while(0)
#define COL2B_SetPullup()          do { WPUEbits.WPUE2 = 1; } while(0)
#define COL2B_ResetPullup()        do { WPUEbits.WPUE2 = 0; } while(0)
#define COL2B_SetPushPull()        do { ODCONEbits.ODCE2 = 0; } while(0)
#define COL2B_SetOpenDrain()       do { ODCONEbits.ODCE2 = 1; } while(0)
#define COL2B_SetAnalogMode()      do { ANSELEbits.ANSE2 = 1; } while(0)
#define COL2B_SetDigitalMode()     do { ANSELEbits.ANSE2 = 0; } while(0)

// get/set SET aliases
#define SET_PORT                 PORTEbits.RE3
#define SET_WPU                  WPUEbits.WPUE3
#define SET_GetValue()           PORTEbits.RE3
#define SET_SetPullup()          do { WPUEbits.WPUE3 = 1; } while(0)
#define SET_ResetPullup()        do { WPUEbits.WPUE3 = 0; } while(0)

/**
   @Param
    none
   @Returns
    none
   @Description
    GPIO and peripheral I/O initialization
   @Example
    PIN_MANAGER_Initialize();
 */
void PIN_MANAGER_Initialize (void);

/**
 * @Param
    none
 * @Returns
    none
 * @Description
    Interrupt on Change Handling routine
 * @Example
    PIN_MANAGER_IOC();
 */
void PIN_MANAGER_IOC(void);


/**
 * @Param
    none
 * @Returns
    none
 * @Description
    Interrupt on Change Handler for the IOCBF0 pin functionality
 * @Example
    IOCBF0_ISR();
 */
void IOCBF0_ISR(void);

/**
  @Summary
    Interrupt Handler Setter for IOCBF0 pin interrupt-on-change functionality

  @Description
    Allows selecting an interrupt handler for IOCBF0 at application runtime
    
  @Preconditions
    Pin Manager intializer called

  @Returns
    None.

  @Param
    InterruptHandler function pointer.

  @Example
    PIN_MANAGER_Initialize();
    IOCBF0_SetInterruptHandler(MyInterruptHandler);

*/
void IOCBF0_SetInterruptHandler(void (* InterruptHandler)(void));

/**
  @Summary
    Dynamic Interrupt Handler for IOCBF0 pin

  @Description
    This is a dynamic interrupt handler to be used together with the IOCBF0_SetInterruptHandler() method.
    This handler is called every time the IOCBF0 ISR is executed and allows any function to be registered at runtime.
    
  @Preconditions
    Pin Manager intializer called

  @Returns
    None.

  @Param
    None.

  @Example
    PIN_MANAGER_Initialize();
    IOCBF0_SetInterruptHandler(IOCBF0_InterruptHandler);

*/
extern void (*IOCBF0_InterruptHandler)(void);

/**
  @Summary
    Default Interrupt Handler for IOCBF0 pin

  @Description
    This is a predefined interrupt handler to be used together with the IOCBF0_SetInterruptHandler() method.
    This handler is called every time the IOCBF0 ISR is executed. 
    
  @Preconditions
    Pin Manager intializer called

  @Returns
    None.

  @Param
    None.

  @Example
    PIN_MANAGER_Initialize();
    IOCBF0_SetInterruptHandler(IOCBF0_DefaultInterruptHandler);

*/
void IOCBF0_DefaultInterruptHandler(void);



#endif // PIN_MANAGER_H
/**
 End of File
*/